#import packages

import numpy as np
import cvxpy as cp

#CVXPY allows also to introduces optimization variables that are vectors or matrices
#the argument denotes the dimension

x = cp.Variable(3)

#to encode vectors we use the array command from the numpy package
#note that this is different from the usual lists format in python!

b = np.array([0.5, 15, 4])
c = np.array([0.75, 0.5, 0.15])

#matrices are written row-wise
A = np.array([[35, 0.5, 0.15], [60, 300, 10], [30, 20, 10]])

#matrix multiplication is denoted by @ instead of *
#the transposition of a matrix/vector is denoted by .T

obj = cp.Minimize(c.T@x)

#inequalities for vectors are considered componentwise
#so, our constraints can be written compactly as

constraints = [A@x >= b, x>=0]
prob = cp.Problem(obj,constraints) 

#We solve the problem
print('We are going to solve the following problem using CVXPY:')
print(prob)
result = prob.solve()

#Print the solution
print('')
print('The status of the the problem is', prob.status)
print('The optimal value of the problem is', prob.value)
print('The optimal solution is x =', x.value)

