#import packages

import numpy as np
import cvxpy as cp

#we introduce the optimization variables by the cp.Variable() command

x = cp.Variable()
y = cp.Variable()
z = cp.Variable()

#We define the optimization problem
#note that powers in python uses the syntax **.
#Alternatively we could have also written x*x or square(x) for the square of x

obj = cp.Minimize(4*x+5*y+3*z)
constraints = [x**2 + 2*y**2 + z**2 <= 4]
prob = cp.Problem(obj,constraints) 

#We solve the problem
print('We solv the following problem using CVXPY:')
print(prob)
result = prob.solve()

#Print the solution
print('')
print('The status of the the problem is', prob.status)
print('The optimal value of the problem is', prob.value)
print('The optimal solution is x =', x.value, 'y =', y.value, 'z =',z.value)

#Think how to obtain the optimal solution analytically. This gives you the solution:
print('')
print('The exact optimal solution is (x,y,z) = -sqrt(8/75)*(4,5/2,3).')
print('The exact optimal value is -sqrt(8/75)*(16 + 25/2 + 9) = -sqrt(150).')
print('')      
print('CVXPY therefore made a mistake of about', (-150**0.5-prob.value))
