#import packages

import numpy as np
import cvxpy as cp

#we introduce the optimization variables by the cp.Variable() command

x = cp.Variable()
y = cp.Variable()

#the command cp.Minimize() or cp.Maximize() are used to defined the objective of our problem
#we can use the usual arithmetic epressions (+,-,*,/) as usual
#a bunch of other allowed expressions can be looked up in the documentation

obj = cp.Minimize(x+y)

#constraints are given as a list of equations and inequalities

constraints = [2*x +y >= 2, x+2*y >= 2]

#we define the problem by the cp.Problem() command.
#print(prob) can be used to display the problem

prob = cp.Problem(obj,constraints) 
print('We solve the following problem using CVXPY:')
print(prob)

#the problem is solved using the .Solve() command. 
#in the background, CVXPY brings the problem in suitable normal form, and solves it
#using an algorithm it selects from several existing open source libraries

result = prob.solve()

#The .status property gives us information on the problem. If the problem was solved correctly,
#the optimal value is saved in the new variable (result), and the .value attribute of the problem
#optimal solutions are saved in the .value of the corresponding variables

print('')
print('The status of the the problem is', prob.status)
print('The optimal value of the problem is', prob.value)
print('The optimal solution is x =', x.value, 'and y =', y.value)

#as we are going to see later in the lecture,
#we can design algorithms that return solutions that are within given error margin
#CVXPY picks such an error margin automatically.

print('')
print('The exact optimal value is 4/3. CVXPY therefore made a mistake of size', (abs(4/3-prob.value)))

#In my case, I got an error of magnitude 10^{-10}.
#setting better error margin is theoretically possible,
#but is a more advanced feature, as it requires manually changing the configurations of the used solvers
#for our purposes, it won't be necessary 

