program block_ctrucnture

  implicit none
  integer :: ifile, imesh, imatrix, imatrixD, ilabels, ignuplot
  integer :: npoin, nelem
  real, dimension(:,:), allocatable :: xi
  integer, dimension(:,:), allocatable :: lnd, iae, ip
  real :: xc(1:2)
  real :: r1, r2

  integer :: i,j, j1, ii, jj, jj1, k, k1, ndim, dof
  integer :: ir, il, ndof

  ndim = 4
  dof = 10
  ndof = ndim * dof
  
  ifile = 10
  imesh = 11
  imatrix = 12
  ilabels = 13
  ignuplot = 14

  open (ifile,STATUS='OLD', file='grid')

  read(ifile, *) npoin, nelem
  read(ifile, *) r1, r2

  allocate(xi(1:npoin, 1:2) )
  allocate(lnd(1:nelem, 1:3) )
  allocate(iae(1:nelem, 1:3) )
  allocate(ip(1:npoin, 0:30) )

  do k=1, npoin
     read(ifile,*) xi(k, 1:2)
  enddo

  do k=1, nelem
     read(ifile,*) i, lnd(k, 1:3)
  enddo

  ! seeking of neighbours
  ip = 0
  do i=1, nelem
     do j=1,3
        k = lnd(i,j)
        ip(k, 0) = ip(k, 0) + 1
        ip(k, ip(k,0) ) = i
     enddo
  enddo
  
        
  iae = -2
  do i=1, nelem
     do j=1, 3
        j1 = mod(j, 3) + 1

        k = lnd(i,j)
        k1 = lnd(i,j1)
        
        do ii=1, ip(k, ip(k,0) )
           do jj=1,3
              jj1 = mod(jj, 3) + 1

              !write(*,'(a8, 20i5)') 'neigh:' i,j,j1, k, k1, ii, jj, jj1, 
              if(k == lnd(ii, jj1)  .and. k1 == lnd(ii, jj) ) then
                 iae(i,j) = ii
                 goto 10
              endif
           enddo
        enddo
10      continue
     enddo
     print*,'lnd:', i,  iae(i, 1:3)
  enddo
  
  
  open(imesh, file='i_mesh',status= 'unknown')
  do i=1, nelem
     write(imesh, *) xi(lnd(i,1), 1:2)
     write(imesh, *) xi(lnd(i,2), 1:2)
     write(imesh, *) xi(lnd(i,3), 1:2)
     write(imesh, *) xi(lnd(i,1), 1:2)
     write(imesh,'(x)')
  enddo


  ! plot the block structure
  open(imatrix, file='i_matrix',status= 'unknown')
  open(imatrixD, file='i_matrixD',status= 'unknown')
  do i=1, nelem
     ir = (i-1)*ndof + 0
     il = (i-1)*ndof + 0

     call draw_block(imatrix,imatrixD, ir, il, ndim, ndof, ndof)

     do j=1, 3
        ii = iae(i, j)

        if(ii > 0) then

           il = (ii-1)*ndof + 0

           call draw_block(imatrix, imatrixD,ir, il, ndim, ndof, ndof)


        endif
     enddo
  enddo

  ! gnuplot
  open(ignuplot, file='i_plot.gnu',status= 'unknown')

  write(ignuplot, *) "set terminal postscript eps color"
  !write(ignuplot, *) "set grid "
  write(ignuplot, *) "set nokey "
  write(ignuplot, *) "set output 'matrix.eps' "

  do i=1, nelem
     xc(1:2) = (xi(lnd(i, 1), 1:2) + xi(lnd(i, 2), 1:2) + xi(lnd(i, 3), 1:2)  )/ 3
     write(ignuplot, '(a11,i3,a3,i3,a4,es14.6,a2,es14.6)' ) &
          "set label ",i,'"K_',i, '" at ', xc(1),',', xc(2)
  enddo
  

  write(ignuplot, *) "plot 'i_mesh' w l"
 
  

  
end program block_ctrucnture


subroutine draw_block(imatrix, imatrixD,ir, il, ndim, ndofx, ndofy)
  integer, intent(in) :: imatrix, imatrixD, ir, il, ndim, ndofx, ndofy
  integer :: dofx, dofy, r, l, jl, jr 
  
  write(imatrix, *) il,      -ir
  write(imatrix, *) il+ndofx, -(ir)
  write(imatrix, *) il+ndofx, -(ir+ndofy)
  write(imatrix, *) il,      -(ir+ndofy)
  write(imatrix, *) il, -ir
  write(imatrix,'(x)')

  dofx = ndofx / ndim
  dofy = ndofy / ndim

  do r=1, ndim
     do l=1, ndim
        jl = il + (l-1)*dofx
        jr = ir + (r-1)*dofy

        write(imatrixd, *) jl,      -jr
        write(imatrixd, *) jl+dofx, -(jr)
        write(imatrixd, *) jl+dofx, -(jr+dofy)
        write(imatrixd, *) jl,      -(jr+dofy)
        write(imatrixd, *) jl, -jr
        write(imatrixd,'(x)')
     enddo
  enddo
  
        
end subroutine draw_block
