#!/bin/bash


if [  "$#" != "6" ]; then
   echo 'Syntax:  PM_comput.sh <case> <dir> <mesh> <P_p> <P_q> <tTOL>'
   echo " <case> = valcovazk"
exit
fi

   case=$1
   dir=$2
   mi=$3
   pi=$4
   ti=$5
   tTOL=$6


   proffile="'../Grids/profiles.0'"
   linefile="'../Grids/lines.0'"

  # case = model
  echo "case=$case"
   
  if [ "$case" == "valcovazk" ]; then

    ttime="1.0"  # 0.1
    grid="'Grids_porous/valcovazk.AA$mi.grid'"

  else
    echo "BAD case $case"
    exit
  fi

  echo $case $dir
  
  
  cat << EOF > comput.ini
porous   1.0000E+00   8   2.5000E-02         ** model: 'scalar/NSe/turb/wet_steam',Re, isca, par
$ttime   4.E-00                         ** final Time, =0 or >1E+10 for steady state
-1.00E-08  1.00E+05  1.00E+06  1.00E+05      ** stopping criteria for steady state: Rez, cDLM
2  $grid                    ** space dim (2,3), file with grid
1  'Grids_porous/profiles.0'   'Grids_porous/lines.0'   ** Q_k curved bnd deg, prof_file, line_file
1       G0.rsol                             ** IC: 1(BC) 0(G0.rsol) (-1=resultsx) (-2=dgm.sol) >0(code)
test                                         ** name of output files (*.sol, *.conv)
IIPG    1.000E+02    $pi                       ** {N}{I}{S}IPG, C_w , p: P_p approx
STDG    $ti                                    ** time discret: 'RK/SEMI/BDF/STDG', q: P_q approx
adapt   $tTOL    tRES                     ** tau: fixed (tau), cfl (cfl), exp (cfl), adapt (tol)|type
interE   1.00E-03    1.0E-03   -1.00   0     ** %estim_space, tol_max, tol_min, state%Lq,iDWR
AMAhp   0     n                          ** mesh adapt 'RGh/RGp/RGhp/AMAh/AMA/hp', adapt levels
 100000                                          ** maximum number of time steps for mesh level
NewtonA  aRES   1.0000E-02   60    20        ** non_solver, stop_crit, tol, max_iter, min C update
 none     GMRES_ILU   1E-3                   ** linear MultiGrid?,  lin_solver   tol 
  1.00E-02     0                             ** output time, isol_start, ini
  2                                          ** number of prescribed Inlet/Outlet BC
    5    0  1.0000E+00                       ** Dirichlet BC: wall index, Dirichlet, val (unused)
    3    3  1.0000E+00                       ** Dirichlet BC: wall index, Dirichlet, val (unused)
   2.00   0.00   0.50   0.00                 ** Stabilization parameters
   0.0    0.0   0.00    0                    ** RTN error estims: gamma_rem, gamm
EOF


  mkdir -p $dir

../SRC_O/Adgfem comput.ini


 
 mv criter PM_flow comput.ini $dir/
 mv Tri*00* Sol*00* tri*00* sol*00* $dir/
 echo "   "
