program trans_NLDwr
  character(len=50) :: datfile, resfile

  idat = 11
  iout = 12
  ilab = 13

  if (command_argument_count() == 2) then
     call get_command_argument(1,datfile)
     open(idat,file=datfile,action='read')
     
     call get_command_argument(2,resfile)
     open(iout,file=resfile,status='UNKNOWN')
  else
     print*,'trans_NLDwr_Alev <input file>  <output file>'
     stop
  endif

  open(ilab,file='labels.gn',status='UNKNOWN')

  ! open(idat, file = 'NLDwr_Alev', status = 'OLD')
  ! open(iout, file = 'NLDwr_Alev1', status = 'unknown')
  
  read(idat, *, end=110) i1, r1

  ipoc = 0
  do i=1, 1000
     read(idat, *, end=110) i1, r1, n1
     read(idat, *, end=110) i2, r2, n2
     r1 =1.25E-4
     
     write(iout, *) i1, r1, i2 - i1, n1+0.5, r1, n2-n1+0.5
     ipoc = ipoc+1
     write(*,'(a9,i3,a6,i3,a1,a5,es12.4,a1,es12.4,a6 )') &
          'set label',ipoc, '"lev=',ipoc-1,'"','  at ', i1 + 0.*(i2-i1),',',r1*2.5,'  left'

     if(ipoc <= 11)&
     write(ilab,'(a9,i3,a12,i2,a1,a5,es12.4,a1,es12.4,a6 )') &
          'set label',ipoc, '"$\\ell\\!=$',ipoc-1,'"','  at ', i1 + 0.15*(i2-i1),',',r1*1.7,'  left'
  enddo

110 continue
  close(iout)
  close(lab)

  print*,'Using in gnuplot:'
  print*,'set style arrow 2 heads nofilled size screen 0.02,8 lw 2 lc 7'
  print*,"p 'NLDwr_Alev1' u 1:2:3:(0) with vectors arrowstyle 2"
  
end program trans_NLDwr
