program read_tri_vtk

  real, dimension(:,:), allocatable :: etas   
  real, dimension(:), allocatable :: xi
  integer, dimension(:), allocatable :: icount
  integer, dimension(:), allocatable :: icountP, pi
  character*80 in_file, out_file, out_fileP, empty
  character*10 emptyA, emptyB, emptyC
  integer:: ires, ires1, n1, n2, nelem, max_eta
  real :: x(1:3), rmax, rmin, raver, rmaxP, rminP, val
  integer :: lnd(1:4)
  integer:: i, j, idx, dof, imax, imin, ifac, iresP
  integer :: iminP, imaxP
  
  !itab = 13
  !open(itab, file='tab.tex',status='UNKNOWN', position='append')

  allocate(xi (1:3) )

  if (command_argument_count() == 3) then
     call get_command_argument(1,in_file)
     
     call get_command_argument(2,out_file)
     
     call get_command_argument(3,out_fileP)
     

  else
     print*,'% Syntax:  re_tri_vtk  <input.dat> <output.dat> '
     stop
  endif

  ires = 11
  open(ires, file=in_file,status='OLD')
  
  ires1 = 12
  open(ires1, file=out_file,status='UNKNOWN') !, position = 'append')
  
  iresP = 13
  open(iresP, file=out_fileP,status='UNKNOWN') !, position = 'append')
  

  read(ires, *) empty
  read(ires, *) empty
  read(ires, *) empty

  !  # 1
  read(ires, *) empty
  read(ires, *) emptyA, n1, emptyB
  !write(*, *) '@@@', emptyA, n1, emptyB

  do i=1,n1
     !write(*, *) '!!!',i,xi(1:3)
     read(ires, *)xi(1:3)

     !write(*, *) '!!!',i,n1,xi(1:3), empty
  enddo
  
 
  !  # 2
  read(ires, *) emptyA, n1, n2
  do i=1,n1
     read(ires, *) lnd(1:4)
     !write(*, *) lnd(1:4)
  enddo

  !  # 3
  read(ires, *) emptyA, nelem
  do i=1,nelem
     read(ires, *) n2
  enddo

  allocate( pi(1:nelem) )

  !  # 4
  dof = 0
  read(ires, *) emptyA, n1
  read(ires, *) empty
  read(ires, *) empty
  do i=1,nelem
     read(ires, *) n2
     dof = dof + (n2+1)*(n2+2)/2
     pi(i) = n2
  enddo

  !  # 5
  read(ires, *) emptyA, emptyB, emptyC, max_eta
  read(ires, *) empty

  allocate( etas(1:nelem, 1:max_eta) )

  do i=1, nelem
     read(ires, *) etas(i, 1:max_eta)
     
  enddo
  

  !idx = 21   ! DWR
  idx = 12   ! inter
  rmax = 0.
  rmin = 1E+20
  rmaxP = 0.
  rminP = 1E+20
  raver = 0
  do i=1, nelem
     
     rmax = max (rmax, etas(i, idx) )
     rmin = min (rmin, etas(i, idx) )
     raver = raver + etas(i, idx) 

     rmaxP = max (rmaxP, etas(i, idx) /(pi(i)+2) )
     rminP = min (rminP, etas(i, idx) /(pi(i)+2) )

  enddo

  raver = raver/nelem
  !write(ires1, *) dof, (1.*dof)**(1./3), rmax, raver, rmin

  ifac = 4

  rmin = max(rmin, 1E-35)
  imax = int(ifac*log10(rmax))-1
  imin = int(ifac*log10(rmin))-1
  
  imin = max(imin, imax-11*ifac)

  imaxP = int(ifac*log10(rmaxP))-1
  iminP = int(ifac*log10(rminP))-1
  
  iminP = max(iminP, imaxP-11*ifac)

  
  write(*, '(a10,i7,3es12.4, 2i6)') 'PARAMS: ', dof, (1.*dof)**(1./3), rmax, rmin, imin,imax
  write(*, '(a10,i7,3es12.4, 2i6)') 'PARAMS: ', dof, (1.*dof)**(1./3), rmaxP, rminP, iminP,imaxP
  
  allocate( icount(imin:imax), source = 0)
  allocate( icountP(iminP:imaxP), source = 0)
  do i=1, nelem
     if(etas(i,idx) > rmin) then
        j = int(ifac*log10(etas(i,idx))) - 1

        if(j >= imin) & !j = imin
             icount(j) = icount(j) +1
     endif

     val = etas(i,idx) / (pi(i) + 2) 
     if(val > rmin) then
        j = int(ifac*log10( val )) - 1

        if(j >= iminP) & !j = imin
             icountP(j) = icountP(j) +1
     endif
  enddo

  do i=imin,imax
     !write(*,*) 1.*i/ifac, 10.**(i), icount(i), 1.* icount(i)/nelem
     write(ires1,*) 1.*i/ifac, 10.**(i), icount(i), 1.* icount(i)/nelem
  enddo

  do i=iminP,imaxP
     !write(*,*) 1.*i/ifac, 10.**(i), icount(i), 1.* icount(i)/nelem
     write(iresP,*) 1.*i/ifac, 10.**(i), icountP(i), 1.* icountP(i)/nelem
  enddo

  close(ires)
  close(ires1)
  close(iresP)
  
  deallocate(etas, icount, xi, pi, icountP)
end program read_tri_vtk
