program extract_convfile
  implicit none
  character(len=50) :: datfile, convfile, texfile
  integer:: i, j,  nmax ,nn,  dmax, idat, itex, iconv
  real :: h, tau 
  real, dimension(:,:), allocatable :: w, r
  integer, dimension(:,:), allocatable :: wi, ri
  logical :: iprint
  
  idat = 11
  iconv = 12
  itex = 13
  if (command_argument_count() == 3) then
     call get_command_argument(1,datfile)
     open(idat, file=datfile, status='OLD')

     call get_command_argument(2,convfile)
     open(iconv, file=convfile, status='OLD')
     
     call get_command_argument(3,texfile)
     open(itex, file=texfile, status='unknown')
     

  else
     print *, "sytax:  extract_convfile <datfile> <convfile> <file.tex>"
     stop
  endif
  
  nmax = 10000
  dmax = 60

  allocate(w(1:nmax, 1:dmax),  wi(1:nmax, 1:dmax) )
  allocate(r(1:nmax, 1:dmax),  ri(1:nmax, 1:dmax) )

  ! order.dat file
  do i=1,nmax
     read(idat, *, end = 120) ri(i,1), r(i, 2:3), ri(i,4)
  enddo
120 continue
  
  nn = 0
  do i=1,nmax
     read(iconv, *, end = 110) wi(i,1), w(i, 2:17), wi(i,18:19), w(i, 20), wi(i,21), &
          w(i,22:26), wi(i, 27), w(i,28:52), wi(i,53), w(i, 54:58), wi(i,59)
     nn = nn + 1
  enddo

110  continue



  do i=1, nn
     iprint = .false.
     if(i == nn) then
        iprint = .true.
     elseif( wi(i,59) < wi(i+1,59) ) then
        iprint = .true.
     endif

     if(iprint) then
        j = wi(i,59)+ 1
        write(*,200) wi(i,59), ri(j,4), w(i, 8:10)
        write(itex,200) wi(i,59), ri(j,4), w(i, 8:10)
     endif
  enddo
200 format(i5, i8, 3es16.7)
  
  deallocate(w, wi, r, ri)
  close(idat)
  close(iconv)
  close(itex)


end program extract_convfile
