module state_of_compute_terms_mod

  implicit none


  type, public :: StateOfComputeTerms_t
      logical, private :: rhs_computed_with_implicitly = .false.

      logical, private :: vec_ready = .false.
      logical, private :: vec_uses_w_plus = .false.
      logical, private :: vec_deg_plus = .false.

      logical, private :: matrix_ready = .false.
      logical, private :: matrix_uses_w_plus = .false.
      logical, private :: matrix_deg_plus = .false.
      logical, private :: DWR_etaI_actual = .false.
    contains

      procedure :: init
      procedure :: print_me

      procedure :: is_res_ready_warning
      procedure :: is_matrix_ready_warning
      procedure :: is_res_ready
      procedure :: is_matrix_ready
      procedure :: update_after_compute_terms
      procedure :: new_w_was_computed
      procedure :: new_z_was_computed
      procedure :: new_w_plus_was_computed

      procedure :: is_DWR_etaI_actual
      procedure :: new_DWR_etaI_was_computed
  end type StateOfComputeTerms_t

  contains

  subroutine init( this )
    class( StateOfComputeTerms_t ), intent( inout ) :: this

      this%rhs_computed_with_implicitly = .false.

      this%vec_ready = .false.
      this%vec_uses_w_plus = .false.
      this%vec_deg_plus = .false.

      this%matrix_ready = .false.
      this%matrix_uses_w_plus = .false.
      this%matrix_deg_plus = .false.

      this%DWR_etaI_actual = .false.
      
  end subroutine init

  subroutine print_me( this )
    class( StateOfComputeTerms_t ), intent( inout ) :: this

      print*, " --- StateOfComputeTerms_t ---"
      print*, " rhs_computed_with_implicitly: ", &
        this%rhs_computed_with_implicitly

      print*, "vec_ready: ", &
        this%vec_ready
      print*, "vec_uses_w_plus: ", &
        this%vec_uses_w_plus
      print*, "vec_deg_plus: ", &
        this%vec_deg_plus

      print*, "matrix_ready: ", &
        this%matrix_ready
      print*, "matrix_uses_w_plus: ", &
        this%matrix_uses_w_plus
      print*, "matrix_deg_plus: ", &
        this%matrix_deg_plus
      print*, " --- ---"

  end subroutine print_me

  subroutine update_after_compute_terms(this, impl, deg_plus, &
      w_plus)
   class( StateOfComputeTerms_t ), intent( inout ) :: this
   logical, intent(in) :: impl, deg_plus, w_plus
!   integer, intent(in) :: p_mod, q_mod

   if (impl) then
      this%rhs_computed_with_implicitly = .true.

      this%matrix_ready = .true.
      this%matrix_uses_w_plus = w_plus
      this%matrix_deg_plus = deg_plus

   else
      this%rhs_computed_with_implicitly = .false.

      this%vec_ready = .true.
      this%vec_uses_w_plus = w_plus
      this%vec_deg_plus = deg_plus

   end if

!   call this%print_me()

  end subroutine update_after_compute_terms

  subroutine new_w_was_computed(this)
    class( StateOfComputeTerms_t ), intent( inout ) :: this

      if (.not. this%vec_uses_w_plus)    this%vec_ready = .false.
      if (.not. this%matrix_uses_w_plus) this%matrix_ready = .false.

      this%DWR_etaI_actual = .false.
      
      !print*, "****"
      !print*, "new_w_was_computed:"
      !print*, "****"
!      call this%print_me()

  end subroutine new_w_was_computed

  subroutine new_w_plus_was_computed(this)
    class( StateOfComputeTerms_t ), intent( inout ) :: this

!      print*, "New wST was computed and hence ComputeTems needs to be called!"

      if (this%vec_uses_w_plus) &
        this%vec_ready = .false.
      if (this%matrix_uses_w_plus) &
        this%matrix_ready = .false.

  end subroutine new_w_plus_was_computed

  ! use only in ComputeST_Terms
  function is_res_ready_warning(this, deg_plus, w_plus) result(ready)
    class( StateOfComputeTerms_t ), intent( inout ) :: this
    logical, intent(in) :: deg_plus, w_plus
    logical :: ready

    ready = .false.

    if (this%vec_ready .and. &
        (this%rhs_computed_with_implicitly .eqv. .false.) .and. &
        (this%vec_uses_w_plus .eqv. w_plus) .and. &
        (this%vec_deg_plus .or. .not. deg_plus)) then
      ready = .true.
    end if

  end function is_res_ready_warning


  function is_res_ready(this, deg_plus, w_plus) result(ready)
    class( StateOfComputeTerms_t ), intent( inout ) :: this
    logical, intent(in) :: deg_plus, w_plus
    logical :: ready

    ready = this%is_res_ready_warning(deg_plus, w_plus)
    if (.not. ready) then
      print*, "Residual vec is NOT ready for:", deg_plus, w_plus
      stop "STOP in is_res_ready"
    end if

  end function is_res_ready

  ! use only in ComputeST_Terms
  function is_matrix_ready_warning(this, deg_plus, w_plus) result(ready)
    class( StateOfComputeTerms_t ), intent( inout ) :: this
    logical, intent(in) :: deg_plus, w_plus
    logical :: ready

    ready = .false.

    if (this%matrix_ready .and. &
        (this%matrix_uses_w_plus .eqv. w_plus) .and. &
        (this%matrix_deg_plus .or. .not. deg_plus)) then
      ready = .true.
    end if

  end function is_matrix_ready_warning

  function is_matrix_ready(this, deg_plus, w_plus) result(ready)
    class( StateOfComputeTerms_t ), intent( inout ) :: this
    logical, intent(in) :: deg_plus, w_plus
    logical :: ready

    ready = this%is_matrix_ready_warning(deg_plus, w_plus)
    if (.not. ready) then
      print*, "Matrix is NOT ready for:", deg_plus, w_plus
      stop "STOP in is_matrix_ready"
    end if

  end function is_matrix_ready


  subroutine new_z_was_computed(this)
    class( StateOfComputeTerms_t ), intent( inout ) :: this

    this%DWR_etaI_actual = .false.
    
  end subroutine new_z_was_computed
  
  subroutine new_DWR_etaI_was_computed(this)
    class( StateOfComputeTerms_t ), intent( inout ) :: this

    this%DWR_etaI_actual = .true.
      
  end subroutine new_DWR_etaI_was_computed


  function is_DWR_etaI_actual(this) result(ready)
    class( StateOfComputeTerms_t ), intent( inout ) :: this
    logical :: ready

    ready = this%DWR_etaI_actual
  end function is_DWR_etaI_actual

end module state_of_compute_terms_mod
