function y = oscillator(t, x)
% OSCILLATOR Right hand side for harmonic oscillator equation:
%
% x_1' = x_2
% x_2' = -b x_1 - a x_2 + c cos(\omega t)

a = 0;
b = 9;
c = 10;
omega = 1;

A = [0 1; -b -a];
r = [0; c*cos(omega*t)];

y = A*x + r;

end